/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.contentassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.contentassist.XMLContentAssistProcessor;
import com.aptana.xml.core.model.AttributeElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;

class XMLAttributeProposal
extends CommonCompletionProposal {
    private int[] _positions;

    XMLAttributeProposal(AttributeElement attribute, String replaceString, int offset, int length, int[] positions) {
        super(replaceString, offset, length, positions[0], XMLContentAssistProcessor.ATTRIBUTE_ICON, attribute.getName(), null, attribute.getDescription());
        this.setFileLocation("XML Core");
        this._positions = positions;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        if (this._positions != null && this._positions.length > 0) {
            IDocument document = viewer.getDocument();
            boolean validPrefix = this.isValidPrefix(this.getPrefix(document, offset), this.getDisplayString());
            int shift = validPrefix ? offset - this._replacementOffset : 0;
            try {
                LinkedModeModel.closeAllModels((IDocument)document);
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                int[] nArray = this._positions;
                int n = this._positions.length;
                int n2 = 0;
                while (n2 < n) {
                    int pos = nArray[n2];
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, offset - shift + pos, 0, i++));
                    model.addGroup(group);
                    ++n2;
                }
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_ALWAYS);
                ui.setExitPosition(viewer, offset - shift + this._positions[this._positions.length - 1], 0, Integer.MAX_VALUE);
                ui.enter();
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

